/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.core.typebinding;

import com.aptana.editor.php.core.model.IMethod;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.core.typebinding.IMethodBinding;
import com.aptana.editor.php.core.typebinding.ITypeBinding;
import com.aptana.editor.php.internal.core.typebinding.MethodBinding;
import java.util.HashSet;
import java.util.List;

public class Bindings {
    public static IMethodBinding findOverriddenMethodInHierarchy(ITypeBinding binding, IMethodBinding methodBinding) {
        String name = methodBinding.getName();
        IType element = binding.getPHPElement();
        HashSet<IType> ts = new HashSet<IType>();
        IMethodBinding m = Bindings.findMethod(element, ts, name);
        return m;
    }

    private static IMethodBinding findMethod(IType element, HashSet<IType> ts, String name) {
        if (!ts.contains(element)) {
            IMethodBinding findMethod;
            ts.add(element);
            List<IMethod> methods = element.getMethods(name);
            if (methods != null && !methods.isEmpty()) {
                IMethod next = methods.iterator().next();
                ISourceModule sourceModule = element.getSourceModule();
                return new MethodBinding(element.getElementName(), name, next.getModifiers(), sourceModule);
            }
            List<IType> superClasses = element.getSuperClasses();
            if (superClasses != null) {
                for (IType t : superClasses) {
                    findMethod = Bindings.findMethod(t, ts, name);
                    if (findMethod == null) continue;
                    return findMethod;
                }
            }
            for (IType t : element.getInterfaces()) {
                findMethod = Bindings.findMethod(t, ts, name);
                if (findMethod == null) continue;
                return findMethod;
            }
        }
        return null;
    }
}

